/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm.mib;

import ibm.nways.jdm.mib.MibAccess;
import ibm.nways.jdm.mib.MibObjectIdentifierValue;
import ibm.nways.jdm.mib.MibRangeSubtype;
import ibm.nways.jdm.mib.MibStatus;
import ibm.nways.jdm.mib.MibType;
import ibm.nways.jdm.mib.MibValue;
import java.io.Serializable;
import java.util.Vector;

public class MibObject
implements Serializable {
    public String name;
    public int access;
    public int status;
    public MibType type;
    public String description;
    public MibObjectIdentifierValue id;
    public Vector indexList;
    public Vector impliedList;
    public String units;
    public MibValue defval;

    public String toString() {
        String string = new String("");
        if (this.name != null) {
            string = String.valueOf(string) + this.name;
        }
        if (this.id != null) {
            string = String.valueOf(string) + "(" + this.id.getValue() + ")";
        }
        if (this.access != 0) {
            string = String.valueOf(string) + ":" + MibAccess.toString(this.access);
        }
        if (this.status != 0) {
            string = String.valueOf(string) + ":" + MibStatus.toString(this.status);
        }
        if (this.type != null) {
            string = String.valueOf(string) + ":" + this.type.toString();
            if (this.isInTable()) {
                string = String.valueOf(string) + "*";
            }
        }
        return string;
    }

    public boolean isInTable() {
        boolean bl = false;
        if (this.type != null) {
            bl = this.type.isInTable();
        }
        return bl;
    }

    public void addIndex(String string, boolean bl) {
        if (this.indexList == null) {
            this.indexList = new Vector();
        }
        if (this.impliedList == null) {
            this.impliedList = new Vector();
        }
        this.indexList.addElement(string);
        this.impliedList.addElement(new Boolean(bl));
    }

    public long getFixedLength() {
        MibRangeSubtype mibRangeSubtype;
        long l = 0L;
        if (this.type != null && (mibRangeSubtype = this.type.getRangeSubtype()) != null && mibRangeSubtype.rangeMinimum() == mibRangeSubtype.rangeMaximum()) {
            l = mibRangeSubtype.rangeMaximum();
        }
        return l;
    }
}

